<?php
@ini_set('display_errors', 1);
@error_reporting(E_ALL);

echo "<h2>🔧 Auto Scan & Hardening WordPress</h2>";

$start_dir = __DIR__;
echo "<p>📂 Start Path: <code>" . htmlspecialchars($start_dir) . "</code></p>";

$wp_config = find_wp_config($start_dir);

if (!$wp_config) {
    echo "<p style='color:red;'>❌ <strong>wp-config.php tidak ditemukan!</strong></p>";
    exit;
}

echo "<p>✅ Ditemukan: <code>" . htmlspecialchars($wp_config) . "</code></p>";

update_wp_config($wp_config);
remove_bad_plugins($wp_config);


// === FUNCTIONS ===

function find_wp_config($start) {
    $dir = realpath($start);
    while ($dir && $dir !== dirname($dir)) {
        $config_path = $dir . '/wp-config.php';
        if (file_exists($config_path)) return $config_path;
        $dir = dirname($dir);
    }
    return false;
}

function update_wp_config($path) {
    if (!is_readable($path)) {
        echo "❌ Tidak bisa membaca <code>" . htmlspecialchars($path) . "</code><br>";
        return;
    }

    $content = file_get_contents($path);
    if ($content === false || trim($content) === '') {
        echo "❌ Gagal baca isi atau file kosong: <code>" . htmlspecialchars($path) . "</code><br>";
        return;
    }

    $changes = [
        "define('DISALLOW_FILE_EDIT', true);" => "✅ Tambah DISALLOW_FILE_EDIT",
        "define('DISALLOW_FILE_MODS', true);" => "✅ Tambah DISALLOW_FILE_MODS",
    ];

    $modified = false;

    foreach ($changes as $define => $message) {
        if (strpos($content, $define) === false) {
            $content .= "\n" . $define;
            echo "$message<br>";
            $modified = true;
        } else {
            echo "ℹ️ Sudah ada: <code>" . htmlspecialchars($define) . "</code><br>";
        }
    }

    if ($modified) {
        if (!is_writable($path)) {
            echo "❌ File tidak bisa ditulis: <code>" . htmlspecialchars($path) . "</code><br>";
            return;
        }

        if (file_put_contents($path, $content) !== false) {
            echo "✅ <strong>wp-config.php berhasil diperbarui!</strong><br>";
        } else {
            echo "❌ Gagal menyimpan perubahan ke wp-config.php<br>";
        }
    }
}

function remove_bad_plugins($wp_config_path) {
    $wp_root = dirname($wp_config_path);
    $plugin_dir = $wp_root . '/wp-content/plugins';

    $targets = [
        'wp-file-manager',
        'file-manager-advanced',
        'yanierin',
        'wpspy',
        'wp-malware-scanner',
        'malicious-uploader',
    ];

    if (!is_dir($plugin_dir)) {
        echo "❌ Tidak ditemukan folder plugin: <code>" . htmlspecialchars($plugin_dir) . "</code><br>";
        return;
    }

    foreach ($targets as $plugin) {
        $path = $plugin_dir . '/' . $plugin;
        if (is_dir($path)) {
            if (delete_directory($path)) {
                echo "🗑️ Hapus plugin <code>" . htmlspecialchars($plugin) . "</code><br>";
            } else {
                echo "❌ Gagal hapus plugin <code>" . htmlspecialchars($plugin) . "</code><br>";
            }
        } else {
            echo "ℹ️ Plugin <code>" . htmlspecialchars($plugin) . "</code> tidak ditemukan<br>";
        }
    }
}

function delete_directory($dir) {
    if (!file_exists($dir)) return false;
    $items = scandir($dir);
    if (!$items) return false;

    foreach ($items as $item) {
        if ($item === '.' || $item === '..') continue;
        $path = $dir . DIRECTORY_SEPARATOR . $item;
        if (is_dir($path)) {
            if (!delete_directory($path)) return false;
        } else {
            if (!@unlink($path)) return false;
        }
    }
    return @rmdir($dir);
}
?>
